#version 330
#extension GL_EXT_gpu_shader4 : enable
//Henon mapsMod01.fsh  by  inou
//https://www.shadertoy.com/view/wltGR7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// K^+ for Hénon maps by Hiroyuki Inou
// Based on (or, small modification of):
// 	Julia - Quaternion by inigo quilez
// 	https://www.shadertoy.com/view/MsfGRr
//
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// antialais level (1, 2, 3...)
#if HW_PERFORMANCE==0
#define AA 1
#else
#define AA 2  // Set AA to 1 if your machine is too slow
#endif


// 0: numerical normals (central differences)
// 1: analytic normals
// 2: analytic normals optimized
#define METHOD 1

const int numIterations = 11;

float map( in vec3 p, out vec4 oTrap, in vec4 c )
{
    vec4 z = vec4(p,0.0);
    float md2 = 1.0;
    float mz2 = dot(z,z);

    mat4x4 J = mat4x4(1,0,0,0, 0,1,0,0, 0,0,1,0, 0,0,0,1);
    
    vec4 trap = vec4(abs(z.xyz),dot(z,z));

    float n = 1.0;
    for( int i=0; i<numIterations; i++ )
    {
        // (x,y) -> (by + x^2 + c, x)
        // J = [[2x, b], [1, 0]]
        // c = (b, c)
        
        // Jacobian (transposed because OpenGL is column major)
		J = J*mat4x4(2.0*z.x, -2.0*z.y, c.x, -c.y,
                     2.0*z.y,  2.0*z.x, c.y,  c.x,
                     1, 0, 0, 0,
                     0, 1, 0, 0);

        z = vec4(c.x*z.z - c.y*z.w  +  z.x*z.x - z.y*z.y + c.z,
                 c.y*z.z + c.x*z.w  +  2.0*z.x*z.y       + c.w,
                 z.x,
                 z.y);
        
        trap = min( trap, vec4(abs(z.xyz),dot(z,z)) );

        mz2 = dot(z.xy,z.xy); // escape to x direction
        if(mz2>50.0) break;
        n += 1.0;
    }
    
    oTrap = trap;
    
    md2 = J[0][0]*J[0][0]+J[0][1]*J[0][1];// + J[0][2]*J[0][2]+J[0][3]*J[0][3];

    return 0.25*sqrt(mz2/md2)*exp2(-n)*log(mz2);  // d = 0.5·|z|·log|z| / |dz|
}

#if METHOD==0
vec3 calcNormal( in vec3 pos, in vec4 c )
{
    vec4 kk;
    vec2 e = vec2(1.0,-1.0)*0.5773*0.001;
    return normalize( e.xyy*map( pos + e.xyy, kk, c ) + 
					  e.yyx*map( pos + e.yyx, kk, c ) + 
					  e.yxy*map( pos + e.yxy, kk, c ) + 
					  e.xxx*map( pos + e.xxx, kk, c ) );
}
#endif

#if METHOD==1
vec3 calcNormal( in vec3 p, in vec4 c )
{
    vec4 z = vec4(p,0.0);

    // identity derivative
    mat4x4 J = mat4x4(1,0,0,0,  
                      0,1,0,0,  
                      0,0,1,0,  
                      0,0,0,1 );

  	for(int i=0; i<numIterations; i++)
    {
        // chain rule of jacobians (transposed because OpenGL is column major)        
        J = J*mat4x4(2.0*z.x, -2.0*z.y, c.x, -c.y,
                   2.0*z.y,  2.0*z.x, c.y,  c.x,
                   1, 0, 0, 0,
                   0, 1, 0, 0);

        // z -> z2 + c
        z = vec4(c.x*z.z - c.y*z.w + z.x*z.x - z.y*z.y + c.z,
                 c.y*z.z + c.x*z.w + 2.0*z.x*z.y + c.w,
                 z.x,
                 z.y);
        
        if(dot(z.xy,z.xy)>50.0) break; // escape to x direction
    }

    return normalize( (J*z).xyz ); // direction of gradient vector
}
#endif
/*
#if METHOD==2
vec3 calcNormal( in vec3 p, in vec4 c )
{
    vec4 z = vec4(p,0.0);

    // identity derivative
    vec4 J0 = vec4(1,0,0,0);
    vec4 J1 = vec4(0,1,0,0);
    vec4 J2 = vec4(0,0,1,0);
    
  	for(int i=0; i<numIterations; i++)
    {
        vec4 cz = qconj(z);
        
        // chain rule of jacobians (removed the 2 factor)
        J0 = vec4( dot(J0,cz), dot(J0.xy,z.yx), dot(J0.xz,z.zx), dot(J0.xw,z.wx) );
        J1 = vec4( dot(J1,cz), dot(J1.xy,z.yx), dot(J1.xz,z.zx), dot(J1.xw,z.wx) );
        J2 = vec4( dot(J2,cz), dot(J2.xy,z.yx), dot(J2.xz,z.zx), dot(J2.xw,z.wx) );

        // z -> z2 + c
        z = qsqr(z) + c; 
        
        if(dot(z,z)>4.0) break;
    }
    
	vec3 v = vec3( dot(J0,z), 
                   dot(J1,z), 
                   dot(J2,z) );

    return normalize( v );
}
#endif

// this method does not work, but in my mind, it should
#if METHOD==3
vec3 calcNormal( in vec3 p, in vec4 c )
{
    vec4 z = vec4(p,0.0);

    vec4 dz = vec4(1,0,0,0);
    
  	for(int i=0; i<numIterations; i++)
    {
        // z' = 2z'z
		dz = 2.0*qmul( z, dz );
        
        // z -> z2 + c
        z = qsqr(z) + c; 
        
        if(dot(z,z)>4.0) break;
    }
    
	vec4 v = qconj(qmul( dz, qconj(z) ));
    
    return normalize( v.xyz );
}
#endif
*/


float intersect( in vec3 ro, in vec3 rd, out vec4 res, in vec4 c )
{
    vec4 tmp;
    float resT = -1.0;
	float maxd = 10.0;
    float h = 1.0;
    float t = 0.0;
    for( int i=0; i<300; i++ )
    {
        if( h<0.0001||t>maxd ) break;
	    h = map( ro+rd*t, tmp, c );
        t += h;
    }
    if( t<maxd ) { resT=t; res = tmp; }

	return resT;
}

float softshadow( in vec3 ro, in vec3 rd, float mint, float k, in vec4 c )
{
    float res = 1.0;
    float t = mint;
    for( int i=0; i<64; i++ )
    {
        vec4 kk;
        float h = map(ro + rd*t, kk, c);
        res = min( res, k*h/t );
        if( res<0.001 ) break;
        t += clamp( h, 0.01, 0.5 );
    }
    return clamp(res,0.0,1.0);
}

vec3 render( in vec3 ro, in vec3 rd, in vec4 c )
{
	const vec3 sun = vec3(  0.577, 0.577,  0.577 );
    
	vec4 tra;
	vec3 col;
    float t = intersect( ro, rd, tra, c );
    if( t < 0.0 )
    {
     	col = vec3(0.7,0.9,1.0)*(0.7+0.3*rd.y);
		col += vec3(0.8,0.7,0.5)*pow( clamp(dot(rd,sun),0.0,1.0), 48.0 );
	}
	else
	{
        vec3 mate = vec3(1.0,0.8,0.7)*0.3;
		//mate.x = 1.0-10.0*tra.x;
        
        vec3 pos = ro + t*rd;
        vec3 nor = calcNormal( pos, c );
        
		float occ = clamp(2.5*tra.w-0.15,0.0,1.0);
		

        col = vec3(0.0);

        // sky
        {
        float co = clamp( dot(-rd,nor), 0.0, 1.0 );
        vec3 ref = reflect( rd, nor );
        //float sha = softshadow( pos+0.0005*nor, ref, 0.001, 4.0, c );
        float sha = occ;
        sha *= smoothstep( -0.1, 0.1, ref.y );
        float fre = 0.1 + 0.9*pow(1.0-co,5.0);
            
		col  = mate*0.3*vec3(0.8,0.9,1.0)*(0.6+0.4*nor.y)*occ;
		col +=  2.0*0.3*vec3(0.8,0.9,1.0)*(0.6+0.4*nor.y)*sha*fre;
        }

        // sun
        {
        const vec3 lig = sun;
        float dif = clamp( dot( lig, nor ), 0.0, 1.0 );
        float sha = softshadow( pos, lig, 0.001, 64.0, c );
        vec3 hal = normalize( -rd+lig );
        float co = clamp( dot(hal,lig), 0.0, 1.0 );
        float fre = 0.04 + 0.96*pow(1.0-co,5.0);
        float spe = pow(clamp(dot(hal,nor), 0.0, 1.0 ), 32.0 );
        col += mate*3.5*vec3(1.00,0.90,0.70)*dif*sha;
        col +=  7.0*3.5*vec3(1.00,0.90,0.70)*spe*dif*sha*fre;
        }

        // extra fill
        {
        const vec3 lig = vec3( -0.707, 0.000, -0.707 );
		float dif = clamp(0.5+0.5*dot(lig,nor), 0.0, 1.0 );
        col += mate* 1.5*vec3(0.14,0.14,0.14)*dif*occ;
        }
        
        // fake SSS
        {
        float fre = clamp( 1.+dot(rd,nor), 0.0, 1.0 );
        col += mate* mate*0.6*fre*fre*(0.2+0.8*occ);
        }
    }

	return pow( col, vec3(0.4545) );
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // anim
    float time = iTime*.15;
    vec4 c = vec4(1.5,1.5,0.7,0.7)*cos( vec4(0.5,3.9,1.4,1.1) + time*vec4(1.2,1.7,1.3,2.5) ) - vec4(0.0,0.0,1.0,0.0);

    // camera
	float r = 1.5+0.15*cos(0.0+0.29*time);
    vec3 ro = vec3(           r*cos(0.3+0.37*time), 
					5.3 + 0.8*r*cos(1.0+0.33*time), 
					          r*cos(2.2+0.31*time) );
    //ro = ro.yxz;
 	vec3 ta = vec3(0.0,0.0,0.0);
    float cr = 0.1*cos(0.1*time);
    
    
    // render
    vec3 col = vec3(0.0);
    for( int j=0; j<AA; j++ )
    for( int i=0; i<AA; i++ )
    {
        vec2 p = (-iResolution.xy + 2.0*(gl_FragCoord.xy + vec2(float(i),float(j))/float(AA))) / iResolution.y;

        vec3 cw = normalize(ta-ro);
        vec3 cp = vec3(sin(cr), cos(cr),0.0);
        vec3 cu = normalize(cross(cw,cp));
        vec3 cv = normalize(cross(cu,cw));
        vec3 rd = normalize( p.x*cu + p.y*cv + 2.0*cw );

        col += render( ro, rd, c );
    }
    col /= float(AA*AA);
    
    vec2 uv = gl_FragCoord.xy / iResolution.xy;
	col *= 0.7 + 0.3*pow(16.0*uv.x*uv.y*(1.0-uv.x)*(1.0-uv.y),0.25);
    
	gl_FragColor = vec4( col, 1.0 );
}
